<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Full-Screen Movie Banner</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: flex-start;
            align-items: center;
            height: 100vh;
            background-color: #000000; /* Cor de fundo até carregar a imagem */
            background-repeat: no-repeat;
            background-size: cover;
            position: relative;
            overflow: hidden;
            transition: background-image 0.5s ease-in-out; /* Transição suave do fundo */
        }
        #movie-container {
            opacity: 0;
            transition: opacity 0.2s ease-in-out;
        }
        .movie-banner {
            display: flex;
            flex-direction: column;
            justify-content: flex-start;
            align-items: center;
            color: #fff;
            padding-left: 0;
            position: relative;
            z-index: 2;
            height: 100%;
        }
        #movie-logo {
            width: 200px;
            height: auto;
            margin-top: 20px;
        }
        .overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(to right, rgba(0, 0, 0, 0.5), transparent);
            z-index: 1;
        }
    </style>
    <!-- Pré-carregar as imagens de fundo e logomarca -->
    <link rel="preload" href="https://i.postimg.cc/dt1gb95j/Design-sem-nome-2025-08-15-T174235-989.png" as="image">
    <link rel="preload" href="https://i.postimg.cc/02yq8vym/Design-sem-nome-2025-08-15-T002150-369.png" as="image">
</head>
<body>
    <div class="movie-container" id="movie-container">
        <div class="overlay" id="viewport_capture">
            <div class="movie-banner">
                <img id="movie-logo" src="https://i.postimg.cc/02yq8vym/Design-sem-nome-2025-08-15-T002150-369.png" alt="Logo">
            </div>
        </div>
    </div>

    <script>
        // Carregar fundo de forma eficiente
        const bgImage = new Image();
        bgImage.src = "https://i.postimg.cc/dt1gb95j/Design-sem-nome-2025-08-15-T174235-989.png";
        bgImage.onload = () => {
            document.body.style.backgroundImage = `url('${bgImage.src}')`;
            document.getElementById('movie-container').style.opacity = 1;
        };
    </script>
</body>
</html>
